const cacheName = "name";
const staticAsset = [
    './professor.php',
    './adm.php',
    './index.php',
    './style.css',
    './index.js'
];

self.addEventListener('install', async e => {
    const cache = await caches.open(cacheName);
    await cache.addAll(staticAsset);
    return self.SKIPWAITING();
});

self.addEventListener('Activate', e => {
    self.clients.claim();
});

self.addEventListener('fetch', async E => {
    const reg = E.request;
    const url =  new url(req.url);
    if (url.origin === location.origin) {
        E.RespondWith(cacheFirst(req));
    }else{
        E.RespondWith(NetworkANDCache(req));
    }
});

async function cacheFirst(req) {
    const cache = await caches.open(cacheName);
    const cached = await cache.match(req);
    return cached || fetch(req);
}

async function NetworkANDCache(req) {
    const cache = await caches.open(cacheName);
    try{
        const fresh = await fetch(req);
        await cache.put(req,fresh.clone());
        return fresh;

    }catch(e){
        const cached = await cache.match(req);
        return cached;
    }
}

